#!/bin/bash
SETCOLOR_SUCCESS="echo -en \\033[1;32m"
SETCOLOR_FAILURE="echo -en \\033[1;31m"
SETCOLOR_INFO="echo -en \\033[1;34m"
SETCOLOR_NORMAL="echo -en \\033[0;39m"

if [ -e /etc/debian_version ]; then
	if [ `cat /etc/debian_version | cut -c-3` == "9.5" ]; then
		OS="debian95"
	elif [ `cat /etc/debian_version | cut -c-3` == "9.9" ]; then
		OS="debian9"
	else
		OS="debian8"
	fi
else
  OS="centos"
fi

if [ "$OS" == "centos" ]; then
#sed -i '/192.168/d' /etc/hosts

yum -y upgrade ca-certificates --disablerepo=epel

#Отключаем репозитории стерхов
yum-config-manager --disable centos71
yum-config-manager --disable centos73
yum-config-manager --disable centos76
yum-config-manager --disable diff

#Устанавливаем библиотеки
yum -y install mesa-dri-drivers llvm-private nss liberation-fonts vulkan libxkbcommon cairo libepoxy libwayland-cursor libwayland-egl glib2 gdk-pixbuf2 jq oniguruma kwallet
yum -y --disablerepo=* remove firefox
find / -name ".mozilla" -exec rm -rf {} \;
rm -rf /usr/lib64/firefox
rm -rf /lib64/firefox

#Скачиваем и устанавливаем браузеры
echo "Идет скачивание пакетов...."
mkdir /home/user/browser/
cd /home/user/browser/
rpm -ih --force https://github.com/deemru/Chromium-Gost/releases/download/107.0.5304.121/chromium-gost-107.0.5304.121-linux-amd64.rpm
rpm -ih --force http://svr.avmas.ru/repo/google-chrome-stable_current_x86_64-107.0.5304.63.rpm
rpm -ih --force --nodeps https://rpmfind.net/linux/centos/7.9.2009/updates/x86_64/Packages/firefox-68.12.0-1.el7.centos.x86_64.rpm
rpm -ih --force http://svr.avmas.ru/repo/yandex-browser-stable-22.11.0.2416.rpm
sed -i 's/chromium-browser/chromium-browser --password-store=basic/g' /home/user/.local/share/applications/chromium-browser.desktop

#Устанавливаем сертификаты
wget https://roskazna.gov.ru/upload/iblock/f5e/Kornevoy-sertifikat-GUTS-2022.CER
/opt/cprocsp/bin/amd64/certmgr -inst -store root -file Kornevoy-sertifikat-GUTS-2022.CER
rm -rf Kornevoy-sertifikat-GUTS-2022.CER

wget https://roskazna.gov.ru/upload/iblock/1af/Kaznacheystvo-Rossii.CER
/opt/cprocsp/bin/amd64/certmgr -inst -store root -file Kaznacheystvo-Rossii.CER
rm -rf Kaznacheystvo-Rossii.CER

wget https://gu-st.ru/content/Other/doc/russian_trusted_root_ca.cer
/opt/cprocsp/bin/amd64/certmgr -inst -store root -file russian_trusted_root_ca.cer
rm -rf russian_trusted_root_ca.cer

#Скачивание и установка


#Прыгающий курсор 5 с
cat <<EOF > /home/user/.kde/share/config/klaunchrc
[BusyCursorSettings]
Blinking=false
Bouncing=true
Timeout=5

[FeedbackStyle]
BusyCursor=true
TaskbarButton=true

[TaskbarButtonSettings]
Timeout=30
EOF
chown user:user /home/user/.kde/share/config/klaunchrc

mkdir -p /etc/firefox/policies/
cat <<EOF > /etc/firefox/policies/policies.json
{
  "policies": {
    "DisableAppUpdate": true
  }
}
EOF

#Ссылка на бинарник
ln -s /usr/lib64/firefox/firefox /usr/bin/firefox

curl -O http://centos.mirror.cdnetworks.com/7.5.1804/cr/x86_64/Packages/gtk3-3.22.30-3.el7.x86_64.rpm
rpm2cpio gtk3-3.22.30-3.el7.x86_64.rpm | cpio -idmv > /dev/null
cp usr/lib64/libgtk-3.so.0.2200.30 /lib64/
cp usr/lib64/libgdk-3.so.0.2200.30 /lib64/
rm -rf usr
rm -rf gtk3-3.22.30-3.el7.x86_64.rpm
pushd /lib64
unlink libgtk-3.so.0
unlink libgdk-3.so.0
ln -s libgtk-3.so.0.2200.30 libgtk-3.so.0
ln -s libgdk-3.so.0.2200.30 libgdk-3.so.0
popd

#Правка меню
cat <<EOF > /usr/share/applications/firefox.desktop
[Desktop Entry]
Comment[ru]=
Comment=
Exec=firefox
GenericName[ru]=Web Browser
GenericName=Web Browser
Icon=/usr/lib64/firefox/browser/chrome/icons/default/default48.png
MimeType=
Name=Web Браузер Firefox
NoDisplay=false
Path=
StartupNotify=true
Terminal=false
TerminalOptions=
Type=Application
X-DBUS-ServiceName=
X-DBUS-StartupType=
X-KDE-SubstituteUID=false
X-KDE-Username=
EOF

cp /usr/share/applications/firefox.desktop /home/user/Рабочий\ стол/firefox.desktop
#sed -i '/firefox/d' /home/user/.config/menu/applications-kmenuedit.menu


#Создаем и настраиваем профиль
su user<<!
firefox -CreateProfile default-esr
!

pushd /home/user/.mozilla/firefox/*.default-esr
cat <<EOF > user.js
user_pref("print.print_margin_bottom","0");
user_pref("print.print_margin_left","0");
user_pref("print.print_margin_right","0");
user_pref("print.print_margin_top","0");
user_pref("print.print_footerleft","");
user_pref("print.print_footerright","");
user_pref("print.print_headerleft","");
user_pref("print.print_headerright","");
user_pref("xpinstall.signatures.required", false);
user_pref("print.tab_modal.enabled", true);
EOF
chown user:user user.js
popd

pushd /usr/share/glib-2.0/schemas/
rm -rf org.gtk.Settings.FileChooser.gschema.xml
curl -O https://gitlab.gnome.org/GNOME/gtk/-/raw/c925221aa804aec344bdfec148a17d23299b6c59/gtk/org.gtk.Settings.FileChooser.gschema.xml
glib-compile-schemas . 2>/dev/null
popd

$SETCOLOR_FAILURE
echo
echo "Сейчас будет запущен firefox"
echo "В нем необходимо согласиться с установкой расширения"
echo "затем закрыть браузер"
echo
$SETCOLOR_NORMAL

sleep 8

su user<<!
firefox -P default-esr https://www.cryptopro.ru/sites/default/files/products/cades/extensions/firefox_cryptopro_extension_latest.xpi
!

$SETCOLOR_SUCCESS

if ! [ -e firefox-107.0.1.tar.bz2 ]; then
wget https://ftp.mozilla.org/pub/firefox/releases/107.0.1/linux-x86_64/ru/firefox-107.0.1.tar.bz2
fi
tar -xvjf firefox-107.0.1.tar.bz2 -C /usr/lib64/
rm -rf firefox-107.0.1.tar.bz2
rm -rf /home/user/browser/
echo "Установка завершена!"
echo "На рабочем столе создан ярлык запуска браузера"
echo
$SETCOLOR_NORMAL

else
	sed -i 's/-src//g' /etc/apt/sources.list
	apt update && apt -y install firefox-esr curl
	curl -O http://repo.s-t.ru/data/chromium-gost-92.0.4515.107-linux-amd64.deb
	dpkg -i chromium-gost-92.0.4515.107-linux-amd64.deb
	rm -rf chromium-gost-92.0.4515.107-linux-amd64.deb
	curl -O http://repo.s-t.ru/data/dashtopanel.tar.gz
	rm -rf /home/user/.local/share/gnome-shell/extensions/dash-to-panel*
	tar -xvzf dashtopanel.tar.gz -C /home/user/.local/share/gnome-shell/extensions/
	rm -rf dashtopanel.tar.gz
	echo
	$SETCOLOR_SUCCESS
	echo "Установка завершена"
	$SETCOLOR_NORMAL
	echo
fi